<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Form;

use Dedi\SyliusContactPlugin\Model\AnswerModel;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotNull;
use Symfony\Component\Workflow\WorkflowInterface;

final class AnswerType extends AbstractType
{
    public function __construct(
        private readonly WorkflowInterface $workflow,
    ) {
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('message', TextareaType::class, [
                'label' => 'dedi_sylius_contact_form.ui.form.message',
                'constraints' => [
                    new NotNull(),
                ],
            ])
            ->add('attachments', AttachmentCollectionType::class)
        ;

        /** @var AnswerModel $answerModel */
        $answerModel = $builder->getData();

        if ($this->workflow->can($answerModel->contactFormMessage, 'process')) {
            $builder
                ->add('process', CheckboxType::class, [
                    'label' => 'dedi_sylius_contact_form.ui.form.mark_as_process',
                    'required' => false,
                ])
            ;
        }
    }
}
