<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Fixture;

use Doctrine\Persistence\ObjectManager;
use Sylius\Bundle\CoreBundle\Fixture\Factory\ExampleFactoryInterface;
use Sylius\Bundle\FixturesBundle\Fixture\FixtureInterface;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;

class SubjectFixture implements FixtureInterface
{
    public function __construct(
        private readonly ObjectManager $objectManager,
        private readonly ExampleFactoryInterface $subjectFactory,
    ) {
    }

    public function getName(): string
    {
        return 'subject';
    }

    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder($this->getName());

        /** @var ArrayNodeDefinition $optionsNode */
        $optionsNode = $treeBuilder->getRootNode();

        $optionsNode
            ->children()
                ->booleanNode('enabled')->defaultTrue()->end()
                ->scalarNode('subject_rank')->end()
                ->scalarNode('code')->end()
                ->arrayNode('translations')
                    ->arrayPrototype()
                        ->children()
                            ->scalarNode('label')->defaultNull()->end()
                            ->scalarNode('recipient_email')->defaultNull()->end()
                        ->end()
                    ->end()
                ->end()
            ->end();

        return $treeBuilder;
    }

    public function load(array $options): void
    {
        $subject = $this->subjectFactory->create($options);
        $this->objectManager->persist($subject);
        $this->objectManager->flush();
    }
}
