<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Fixture\Factory;

use Dedi\SyliusContactPlugin\Entity\ContactFormSubjectInterface;
use Dedi\SyliusContactPlugin\Entity\ContactFormSubjectTranslation;
use Dedi\SyliusContactPlugin\Factory\ContactFormSubjectFactoryInterface;
use Sylius\Bundle\CoreBundle\Fixture\Factory\ExampleFactoryInterface;

class SubjectFactory implements ExampleFactoryInterface
{
    public function __construct(
        private readonly ContactFormSubjectFactoryInterface $subjectFactory,
    ) {
    }

    public function create(array $options = []): ContactFormSubjectInterface
    {
        /** @var ContactFormSubjectInterface|null $subject */
        $subject = $this->subjectFactory->createNew();

        $subject->setSubjectRank($options['subject_rank']);
        $subject->setActive($options['enabled']);
        $subject->setCode($options['code']);

        foreach ($options['translations'] as $localeCode => $translation) {
            $translationLocal = new ContactFormSubjectTranslation();

            $translationLocal->setRecipientEmail($translation['recipient_email']);
            $translationLocal->setLabel($translation['label']);
            $translationLocal->setLocale($localeCode);

            $subject->addTranslation($translationLocal);
        }

        return $subject;
    }
}
