<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Fixture\Factory;

use Dedi\SyliusContactPlugin\Entity\ContactFormMessageInterface;
use Dedi\SyliusContactPlugin\Factory\ContactFormMessageFactoryInterface;
use Dedi\SyliusContactPlugin\Repository\ContactFormSubjectRepositoryInterface;
use Faker\Factory;
use Faker\Generator;
use Sylius\Bundle\CoreBundle\Fixture\Factory\AbstractExampleFactory;
use Sylius\Bundle\CoreBundle\Fixture\OptionsResolver\LazyOption;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ContactFormMessageFactory extends AbstractExampleFactory
{
    private Generator $faker;

    private OptionsResolver $optionsResolver;

    public function __construct(
        private readonly ContactFormMessageFactoryInterface $messageFactory,
        private readonly ContactFormSubjectRepositoryInterface $subjectRepository,
    ) {
        $this->faker = Factory::create();
        $this->optionsResolver = new OptionsResolver();

        $this->configureOptions($this->optionsResolver);
    }

    public function create(array $options = []): ContactFormMessageInterface
    {
        $options = $this->optionsResolver->resolve($options);

        $subject = $this->subjectRepository->findOneBy(['code' => $options['subject_code']]);

        if (null === $subject) {
            throw new \InvalidArgumentException('Subject not found');
        }

        /** @var ContactFormMessageInterface $messageContact */
        $messageContact = $this->messageFactory->createNew();

        $messageContact
            ->setSubject($subject)
            ->setName($options['name'])
            ->setEmail($options['email'])
            ->setPhone($options['phone'])
            ->setMessage($options['message'])
            ->setProcessState(ContactFormMessageInterface::STATE_TO_BE_PROCESSED)
            ->setIp($options['ip'])
        ;

        return $messageContact;
    }

    protected function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefault('subject_id', LazyOption::randomOne($this->subjectRepository))
            ->setDefault('subject_code', $this->faker->randomElement(['AFTER_SALES', 'PROMOTIONAL_CODE', 'PARTNERSHIP']))
            ->setDefault('name', fn (Options $options): string => $this->faker->name())
            ->setDefault('email', fn (Options $options): string => $this->faker->email())
            ->setDefault('phone', fn (Options $options) => $this->faker->phoneNumber())
            ->setDefault('message', fn (Options $options): string => $this->faker->text())
            ->setDefault('ip', fn (Options $options) => $this->faker->ipv4())
        ;
    }
}
