<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Fixture;

use Sylius\Bundle\CoreBundle\Fixture\AbstractResourceFixture;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;

class ContactFormMessageFixture extends AbstractResourceFixture
{
    public function configureResourceNode(ArrayNodeDefinition $resourceNode): void
    {
        $resourceNode
            ->children()
                ->scalarNode('subject_code')->cannotBeEmpty()->end()
                ->scalarNode('name')->cannotBeEmpty()->end()
                ->scalarNode('email')->cannotBeEmpty()->end()
                ->scalarNode('phone')->cannotBeEmpty()->end()
                ->scalarNode('message')->cannotBeEmpty()->end()
            ->end();
    }

    public function getName(): string
    {
        return 'contact_message';
    }
}
