<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Factory;

use Dedi\SyliusContactPlugin\Entity\ContactFormSubject;
use Dedi\SyliusContactPlugin\Entity\ContactFormSubjectInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Locale\Context\LocaleContextInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

class ContactFormSubjectFactory implements ContactFormSubjectFactoryInterface
{
    public function __construct(
        private readonly ChannelContextInterface $channelContext,
        private readonly LocaleContextInterface $localeContext,
        private readonly TranslatorInterface $translator,
    ) {
    }

    public function createNew(): ContactFormSubject
    {
        return new ContactFormSubject();
    }

    public function createDefault(): ContactFormSubjectInterface
    {
        $subject = $this->createNew();
        $subject->setCurrentLocale($this->localeContext->getLocaleCode());

        return $subject
            ->setLabel($this->translator->trans('dedi_sylius_contact_form.ui.open_subject', [], 'messages'))
            ->setRecipientEmail($this->getRecipientEmail())
        ;
    }

    protected function getRecipientEmail(): string
    {
        /** @var ChannelInterface $channel */
        $channel = $this->channelContext->getChannel();

        return $channel->getContactEmail() ?? sprintf('no-reply@%s', $channel->getHostname());
    }
}
