<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Factory;

use DateTime;
use Dedi\SyliusContactPlugin\Entity\ContactFormMessage;
use Dedi\SyliusContactPlugin\Entity\ContactFormMessageInterface;
use Dedi\SyliusContactPlugin\Entity\ContactFormSubjectInterface;
use Symfony\Component\HttpFoundation\Request;

class ContactFormMessageFactory implements ContactFormMessageFactoryInterface
{
    public function __construct(
        private readonly AttachmentFactoryInterface $attachmentFactory,
    ) {
    }

    /**
     * @return ContactFormMessage
     */
    public function createNew()
    {
        return new ContactFormMessage();
    }

    public function createNewFromSubjectDataAndRequest(
        ContactFormSubjectInterface $subject,
        array $data,
        Request $request,
    ): ContactFormMessageInterface {
        $contactMessage = $this->createNew();

        $contactMessage
            ->setSubject($subject)
            ->setName($data['name'])
            ->setEmail($data['email'])
            ->setPhone($data['phone'])
            ->setMessage($data['message'])
            ->setIp($request->getClientIp())
            ->setProcessState(ContactFormMessageInterface::STATE_TO_BE_PROCESSED)
        ;

        $contactMessage->setCreatedAt(new DateTime());
        $contactMessage->setUpdatedAt(new DateTime());

        foreach ($data['attachments'] as $attachment) {
            $contactMessage
                ->addAttachment($this->attachmentFactory->createNewFromUploadedFile(
                    $attachment,
                ))
            ;
        }

        return $contactMessage;
    }
}
