<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Factory;

use Dedi\SyliusContactPlugin\Entity\Attachment;
use Dedi\SyliusContactPlugin\Entity\AttachmentInterface;
use Dedi\SyliusContactPlugin\Uploader\AttachmentFileUploaderInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class AttachmentFactory implements AttachmentFactoryInterface
{
    public function __construct(
        private readonly AttachmentFileUploaderInterface $attachmentFileUploader,
    ) {
    }

    public function createNew()
    {
        return new Attachment();
    }

    public function createNewFromUploadedFile(UploadedFile $file): AttachmentInterface
    {
        /** @var AttachmentInterface $attachment */
        $attachment = $this->createNew();
        $attachment->setPath(
            $this->attachmentFileUploader->upload($file),
        );

        return $attachment;
    }
}
