<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Factory;

use DateTime;
use Dedi\SyliusContactPlugin\Entity\Answer;
use Dedi\SyliusContactPlugin\Entity\AnswerInterface;
use Dedi\SyliusContactPlugin\Model\AnswerModel;

final class AnswerFactory implements AnswerFactoryInterface
{
    public function __construct(
        private readonly AttachmentFactoryInterface $attachmentFactory,
    ) {
    }

    public function createNew()
    {
        return new Answer();
    }

    public function createNewFromAnswerModel(AnswerModel $answerModel): AnswerInterface
    {
        /** @var AnswerInterface $answer */
        $answer = $this->createNew();
        $answer->setAuthor($answerModel->author)
            ->setMessage($answerModel->message)
            ->setCreatedAt(new DateTime())
        ;

        foreach ($answerModel->attachments as $attachment) {
            $answer->addAttachment($this->attachmentFactory->createNewFromUploadedFile(
                $attachment,
            ));
        }

        return $answer;
    }
}
