<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\EventListener;

use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

class AdminMenuListener
{
    public function __invoke(MenuBuilderEvent $event)
    {
        $menu = $event->getMenu();

        $menu
            ->addChild('dedi_sylius_contact')
            ->setLabel('dedi_sylius_contact_form.ui.menu.contact')
            ->setLabelAttribute('icon', 'tabler:mail')
        ;

        $child = $menu->getChild('dedi_sylius_contact');
        $child
            ->addChild('dedi_sylius_contact_subject_management', ['route' => 'dedi_sylius_contact_form_admin_subject_index'])
            ->setLabel('dedi_sylius_contact_form.ui.menu.subject')
        ;

        $child
            ->addChild('dedi_sylius_contact_message_management', ['route' => 'dedi_sylius_contact_form_admin_message_index'])
            ->setLabel('dedi_sylius_contact_form.ui.menu.messages')
        ;
    }
}
