<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Entity;

use Sylius\Component\Resource\Model\AbstractTranslation;

/**
 * Class ContactFormSubjectTranslation
 */
class ContactFormSubjectTranslation extends AbstractTranslation implements ContactFormSubjectTranslationInterface
{
    protected ?int $id = null;

    protected ?string $label = null;

    protected ?string $recipientEmail = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getLabel(): ?string
    {
        return $this->label;
    }

    public function setLabel(?string $label): self
    {
        $this->label = $label;

        return $this;
    }

    public function getRecipientEmail(): ?string
    {
        return $this->recipientEmail;
    }

    public function setRecipientEmail(?string $recipientEmail): self
    {
        $this->recipientEmail = $recipientEmail;

        return $this;
    }
}
