<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Entity;

use Sylius\Component\Resource\Model\CodeAwareInterface;
use Sylius\Component\Resource\Model\ResourceInterface;
use Sylius\Component\Resource\Model\TranslatableInterface;

interface ContactFormSubjectInterface extends ResourceInterface, TranslatableInterface, CodeAwareInterface
{
    public function getId(): ?int;

    public function isActive(): bool;

    public function setActive(bool $active): self;

    public function getSubjectRank(): ?int;

    public function setSubjectRank(?int $subjectRank): self;

    public function getLabel(): string;

    public function setLabel(string $label): self;

    public function getRecipientEmail(): string;

    public function setRecipientEmail(string $recipientEmail): self;
}
