<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Entity;

use Sylius\Component\Resource\Model\TranslatableTrait;
use Sylius\Resource\Model\TranslationInterface;

/**
 * Class ContactFormSubject
 */
class ContactFormSubject implements ContactFormSubjectInterface
{
    use TranslatableTrait {
        __construct as private initializeTranslationsCollection;
    }

    public function __construct()
    {
        $this->initializeTranslationsCollection();
    }

    protected ?int $id = null;

    protected bool $active = true;

    protected ?int $subjectRank = 10;

    protected ?string $code = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function isActive(): bool
    {
        return $this->active;
    }

    public function setActive(bool $active): self
    {
        $this->active = $active;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): void
    {
        $this->code = $code;
    }

    public function getSubjectRank(): ?int
    {
        return $this->subjectRank;
    }

    public function setSubjectRank(?int $subjectRank): self
    {
        $this->subjectRank = $subjectRank;

        return $this;
    }

    protected function createTranslation(): TranslationInterface
    {
        return new ContactFormSubjectTranslation();
    }

    public function getLabel(): string
    {
        /** @var ContactFormSubjectTranslation $translation */
        $translation = $this->getTranslation();

        return $translation->getLabel();
    }

    public function setLabel(string $label): self
    {
        /** @var ContactFormSubjectTranslation $translation */
        $translation = $this->getTranslation();
        $translation->setLabel($label);

        return $this;
    }

    public function getRecipientEmail(): string
    {
        /** @var ContactFormSubjectTranslation $translation */
        $translation = $this->getTranslation();

        return $translation->getRecipientEmail();
    }

    public function setRecipientEmail(string $recipientEmail): self
    {
        /** @var ContactFormSubjectTranslation $translation */
        $translation = $this->getTranslation();
        $translation->setRecipientEmail($recipientEmail);

        return $this;
    }

    public function __toString()
    {
        return $this->getLabel();
    }
}
