<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Entity;

use DateTimeInterface;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Resource\Model\ResourceInterface;

interface ContactFormMessageInterface extends ResourceInterface
{
    public const STATE_TO_BE_PROCESSED = 'to_be_processed';

    public const STATE_PROCESSED = 'processed';

    public function getId(): ?int;

    public function getSubject(): ContactFormSubjectInterface;

    public function setSubject(ContactFormSubjectInterface $subject): self;

    public function getName(): ?string;

    public function getPhone(): ?string;

    public function getMessage(): ?string;

    public function getIp(): ?string;

    public function getCreatedAt(): ?DateTimeInterface;

    public function getUpdatedAt(): ?DateTimeInterface;

    public function getEmail(): ?string;

    public function getProcessState(): ?string;

    public function getAnswers(): Collection;

    public function addAnswer(AnswerInterface $answer): self;

    public function removeAnswer(AnswerInterface $answer): self;

    public function hasAnswer(AnswerInterface $answer): bool;

    public function getAttachments(): Collection;

    public function addAttachment(AttachmentInterface $attachment): self;

    public function removeAttachment(AttachmentInterface $attachment): self;

    public function hasAttachment(AttachmentInterface $attachment): bool;

    public function setName(?string $name): self;

    public function setPhone(?string $phone): self;

    public function setMessage(?string $message): self;

    public function setIp(?string $ip): self;

    public function setProcessState(?string $processState): self;

    public function setEmail(?string $email): self;
}
