<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Resource\Model\TimestampableTrait;

class ContactFormMessage implements ContactFormMessageInterface
{
    use TimestampableTrait;

    protected ?int $id = null;

    protected ContactFormSubjectInterface $subject;

    protected ?string $name = null;

    protected ?string $email = null;

    protected ?string $phone = null;

    protected ?string $message = null;

    protected ?string $ip = null;

    protected ?string $processState = null;

    protected Collection $answers;

    protected Collection $attachments;

    public function __construct()
    {
        $this->answers = new ArrayCollection();
        $this->attachments = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSubject(): ContactFormSubjectInterface
    {
        return $this->subject;
    }

    public function setSubject(ContactFormSubjectInterface $subject): self
    {
        $this->subject = $subject;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(?string $phone): self
    {
        $this->phone = $phone;

        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(?string $message): self
    {
        $this->message = $message;

        return $this;
    }

    public function getIp(): ?string
    {
        return $this->ip;
    }

    public function setIp(?string $ip): self
    {
        $this->ip = $ip;

        return $this;
    }

    public function getProcessState(): ?string
    {
        return $this->processState;
    }

    public function setProcessState(?string $processState): self
    {
        $this->processState = $processState;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getAnswers(): Collection
    {
        return $this->answers;
    }

    public function addAnswer(AnswerInterface $answer): self
    {
        if (!$this->hasAnswer($answer)) {
            $answer->setContactFormMessage($this);
            $this->answers->add($answer);
        }

        return $this;
    }

    public function removeAnswer(AnswerInterface $answer): self
    {
        if ($this->hasAnswer($answer)) {
            $answer->setContactFormMessage(null);
            $this->answers->removeElement($answer);
        }

        return $this;
    }

    public function hasAnswer(AnswerInterface $answer): bool
    {
        return $this->answers->contains($answer);
    }

    public function getAttachments(): Collection
    {
        return $this->attachments;
    }

    public function addAttachment(AttachmentInterface $attachment): self
    {
        if (!$this->hasAttachment($attachment)) {
            $attachment->setContactFormMessage($this);
            $this->attachments->add($attachment);
        }

        return $this;
    }

    public function removeAttachment(AttachmentInterface $attachment): self
    {
        if ($this->hasAttachment($attachment)) {
            $attachment->setContactFormMessage(null);
            $this->attachments->removeElement($attachment);
        }

        return $this;
    }

    public function hasAttachment(AttachmentInterface $attachment): bool
    {
        return $this->attachments->contains($attachment);
    }
}
