<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Entity;

class Attachment implements AttachmentInterface
{
    protected ?int $id = null;

    protected ?string $path = null;

    protected ?ContactFormMessageInterface $contactFormMessage = null;

    protected ?AnswerInterface $answer = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPath(): ?string
    {
        return $this->path;
    }

    public function setPath(?string $path): AttachmentInterface
    {
        $this->path = $path;

        return $this;
    }

    public function getContactFormMessage(): ContactFormMessageInterface
    {
        return $this->contactFormMessage;
    }

    public function setContactFormMessage(?ContactFormMessageInterface $contactFormMessage): AttachmentInterface
    {
        $this->contactFormMessage = $contactFormMessage;

        return $this;
    }

    public function getAnswer(): ?AnswerInterface
    {
        return $this->answer;
    }

    public function setAnswer(?AnswerInterface $answer): AttachmentInterface
    {
        $this->answer = $answer;

        return $this;
    }
}
