<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Entity;

use DateTimeInterface;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\AdminUserInterface;
use Sylius\Component\Resource\Model\ResourceInterface;

interface AnswerInterface extends ResourceInterface
{
    public function getAuthor(): ?AdminUserInterface;

    public function setAuthor(?AdminUserInterface $author): self;

    public function getMessage(): ?string;

    public function setMessage(?string $message): self;

    public function setContactFormMessage(?ContactFormMessageInterface $contactFormMessage): self;

    public function getContactFormMessage(): ?ContactFormMessageInterface;

    public function getCreatedAt(): ?DateTimeInterface;

    public function setCreatedAt(?DateTimeInterface $createdAt): self;

    public function getAttachments(): Collection;

    public function addAttachment(AttachmentInterface $attachment): self;

    public function removeAttachment(AttachmentInterface $attachment): self;

    public function hasAttachment(AttachmentInterface $attachment): bool;
}
