<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Entity;

use DateTimeInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\AdminUserInterface;

class Answer implements AnswerInterface
{
    protected ?int $id = null;

    protected ?ContactFormMessageInterface $contactFormMessage = null;

    protected ?AdminUserInterface $author = null;

    private Collection $attachments;

    protected ?string $message = null;

    protected ?DateTimeInterface $createdAt = null;

    public function __construct()
    {
        $this->attachments = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAuthor(): ?AdminUserInterface
    {
        return $this->author;
    }

    public function setAuthor(?AdminUserInterface $author): AnswerInterface
    {
        $this->author = $author;

        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(?string $message): AnswerInterface
    {
        $this->message = $message;

        return $this;
    }

    public function getContactFormMessage(): ?ContactFormMessageInterface
    {
        return $this->contactFormMessage;
    }

    public function setContactFormMessage(?ContactFormMessageInterface $contactFormMessage): AnswerInterface
    {
        $this->contactFormMessage = $contactFormMessage;

        return $this;
    }

    public function getCreatedAt(): ?DateTimeInterface
    {
        return $this->createdAt;
    }

    public function setCreatedAt(?DateTimeInterface $createdAt): AnswerInterface
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getAttachments(): Collection
    {
        return $this->attachments;
    }

    public function addAttachment(AttachmentInterface $attachment): self
    {
        if (!$this->hasAttachment($attachment)) {
            $attachment->setAnswer($this);
            $this->attachments->add($attachment);
        }

        return $this;
    }

    public function removeAttachment(AttachmentInterface $attachment): self
    {
        if ($this->hasAttachment($attachment)) {
            $attachment->setAnswer(null);
            $this->attachments->removeElement($attachment);
        }

        return $this;
    }

    public function hasAttachment(AttachmentInterface $attachment): bool
    {
        return $this->attachments->contains($attachment);
    }
}
