<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;

final class DediSyliusContactPluginExtension extends Extension
{
    /**
     * @inheritdoc
     */
    public function load(array $config, ContainerBuilder $container): void
    {
        $config = $this->processConfiguration($this->getConfiguration([], $container), $config);
        $loader = new XmlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));

        $loader->load('services.xml');

        $container->setParameter('dedi_contact_invisible_captcha', $config['invisible_captcha']);
        $container->setParameter('dedi_contact_phone_pattern', $config['phone_pattern']);
        $container->setParameter('dedi_contact_attachment_help_extensions', $config['attachment_help_extensions']);
        $container->setParameter('dedi_contact_attachment_directory_path', $config['attachment_directory_path']);
        $container->setParameter('dedi_contact_attachment_max_files', $config['attachment_max_files']);
        $container->setParameter('dedi_contact_attachment_max_size', $config['attachment_max_size']);
        $container->setParameter('dedi_contact_attachment_mime_types', $config['attachment_mime_types']);
    }
}
