<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    /**
     * @inheritdoc
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_contact_plugin');
        if (\method_exists($treeBuilder, 'getRootNode')) {
            $rootNode = $treeBuilder->getRootNode();
        } else {
            // BC layer for symfony/config 4.1 and older
            $rootNode = $treeBuilder->root('dedi_sylius_contact_plugin');
        }

        $rootNode
            ->children()
                ->booleanNode('invisible_captcha')->defaultFalse()->end()
                ->scalarNode('phone_pattern')->defaultValue('^(?:0|\(?\+33\)?\s?|0033\s?)[1-79](?:[\.\-\s]?\d\d){4}$')->end()
                ->scalarNode('attachment_help_extensions')->defaultValue('.jpg, .jpeg, .png, .gif, .tif, .bmp, .pdf, .doc, .docx, .xls, .xlsx')->end()
                ->scalarNode('attachment_directory_path')->isRequired()->end()
                ->scalarNode('attachment_max_files')->defaultValue(5)->end()
                ->scalarNode('attachment_max_size')->defaultValue('2M')->end()
                ->arrayNode('attachment_mime_types')
                    ->prototype('scalar')->end()
                    ->defaultValue([
                        'image/jpeg',
                        'image/png',
                        'image/gif',
                        'image/tiff',
                        'image/bmp',
                        'application/pdf',
                        'application/x-pdf',
                        'application/msword',
                        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                        'application/vnd.ms-excel',
                        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                    ])
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
