<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin;

use Dedi\SyliusContactPlugin\DependencyInjection\DediSyliusContactPluginExtension;
use Sylius\Bundle\CoreBundle\Application\SyliusPluginTrait;
use Symfony\Component\DependencyInjection\Extension\ExtensionInterface;
use Symfony\Component\HttpKernel\Bundle\Bundle;

final class DediSyliusContactPlugin extends Bundle
{
    use SyliusPluginTrait;

    public function getContainerExtension(): ?ExtensionInterface
    {
        if (null === $this->extension) {
            $this->extension = new DediSyliusContactPluginExtension();
        }

        return $this->extension;
    }
}
