<?php

declare(strict_types=1);

namespace Dedi\SyliusContactPlugin\Controller\Admin;

use Dedi\SyliusContactPlugin\Entity\AttachmentInterface;
use Sylius\Component\Resource\Repository\RepositoryInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;

class AttachmentDownloaderAction extends AbstractController
{
    public function __construct(
        private readonly RepositoryInterface $repository,
    ) {
    }

    public function __invoke(
        int $id,
    ): Response {
        /** @var ?AttachmentInterface $attachment */
        $attachment = $this->repository->find($id);
        if (null === $attachment) {
            throw $this->createNotFoundException();
        }

        return $this->file($attachment->getPath());
    }
}
