# Installation

Run `composer require dedi/sylius-contact-plugin`

Add the plugin and dependency classes to your `config/bundles.php` :

```php
<?php

return [
    //..
    Dedi\SyliusContactPlugin\DediSyliusContactPlugin::class => ['all' => true],
    EWZ\Bundle\RecaptchaBundle\EWZRecaptchaBundle::class => ['all' => true]
    ];
```

Create `dedi_sylius_contact_plugin.yaml` file into `config/packages` folder to import the plugin's config

```yaml
# config/packages/dedi_sylius_contact_plugin.yaml
imports:
  - { resource: "@DediSyliusContactPlugin/Resources/config/config.yaml" }
```

Configure `EWZRecaptchaBundle`

```.env.local

# Recaptcha activation
GOOGLE_RECAPTCHA_ENABLED=
# Recaptcha public key setter for contact form
GOOGLE_RECAPTCHA_SITE_KEY=
# Recaptcha secret key setter for contact form
GOOGLE_RECAPTCHA_SECRET=
```
Use [ReCaptcha Admin](https://www.google.com/recaptcha/admin) to generate your keys

By default, we use environment variables to store Recaptcha credentials, but you can change this behavior by overriding the `ewz_recaptcha` key in your config :

```yaml
# config/packages/ewz_recaptcha.yaml
ewz_recaptcha:
    public_key: '%env(GOOGLE_RECAPTCHA_SITE_KEY)%'
    private_key: '%env(GOOGLE_RECAPTCHA_SECRET)%'
    enabled: '%env(bool:GOOGLE_RECAPTCHA_ENABLED)%'
```

Import the routes

:warning: routes must be imported after `sylius_shop` to override them

```yaml
# config/routes/sylius_shop.yaml

...

dedi_sylius_contact_form_plugin:
    resource: "@DediSyliusContactPlugin/Resources/config/routing.yaml"
```

Create and execute database migrations

```bash
    bin/console doctrine:migrations:diff
    bin/console doctrine:migrations:migrate
```

[Optionnal] Configure the plugin

```yaml
dedi_sylius_contact_plugin:
    invisible_captcha: false # false by default
    phone_pattern: '^(?:0|\(?\+33\)?\s?|0033\s?)[1-79](?:[\.\-\s]?\d\d){4}$' # french phone number pattern by default
    attachment_directory_path: # required
    attachment_max_files: 5 # maximum number of files that can be uploaded at once
    attachment_max_size: '2M' # maximum sigle file size
    attachment_help_extensions: '.jpg, .jpeg, .png, .gif, .tif, .bmp, .pdf, .doc, .docx, .xls, .xlsx' # allowed file types (used as a readable message)
    attachment_mime_types: # allowed mime types (used in symfony form constraints)
        - 'image/jpeg'
        - 'image/png'
        - 'image/gif'
        - 'image/tiff'
        - 'image/bmp'
        - 'application/pdf'
        - 'application/x-pdf'
        - 'application/msword'
        - 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
        - 'application/vnd.ms-excel'
        - 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
```

[Optionnal] Override the templates

```bash
    mkdir -p templates/bundles/DediSyliusContactPlugin/
    cp -R vendor/dedi/sylius-contact-plugin/src/Resources/views/* templates/bundles/DediSyliusContactPlugin/
```

The template you should override is `Shop/ContactFormSubject/form.html.twig`

