# Features

- [Features](#features)
  * [Subjects](#subjects)
  * [Contact Request Administration](#contact-request-administration)
  * [ReCaptcha](#recaptcha)
  * [Phone Validation](#phone-number-validation)

## Subjects

You can add subjects to your contact form. Your customer will be asked to choose a subject for the request. Depending on this choice, the contact request will be sent to the mail address configured for the given subject.

To add subjects, simply go to your admin panel. In the Contact Requests > Subjects section of your admin panel, you can add, edit and delete subjects. 

![Subject List](./data/contact_plugin_subject_admin_list.png)

For each subject, you can configure the label displayed in the subject choice list of your contact form as well as the mail to which the contact request will be sent to.

Those informations are entirely translatable.

The rank let's you choose the order used to display subjects in your contact form. 

![Subject Configuration](./data/contact_plugin_subject_admin_edit.png)

Note : if there is no subject configured in the admin panel, the subject choice list won't be displayed

![Subject Choice List](./data/contact_plugin_subject_choice_list.png)

### Contact Request Administration

You can see all your contact request in the Contact Requests > Messages section of your admin panel. 

![Contact Request List](./data/contact_plugin_contact_request_list.png)

![Contact Request View](./data/contact_plugin_contact_request_view.png)

### ReCaptcha

You can disable ReCaptcha validation or use it in visible or invisible mode, depending on the `invisible_captcha` config value :

```yaml
# config/packages/dedi_sylius_contact_plugin.yaml
dedi_sylius_contact_plugin:
  invisible_captcha: true # false by default
```

![ReCaptcha Visible](./data/contact_plugin_recaptcha_visible.png)

![ReCaptcha Invisible](./data/contact_plugin_recaptcha_invisible.png)

### Phone Number Validation

You can change the pattern used to validate phone numbers by setting the key `phone_pattern` in your config : 

```yaml
# config/packages/dedi_sylius_contact_plugin.yaml
dedi_sylius_contact_plugin:
  phone_pattern: '/^(?:0|\(?\+33\)?\s?|0033\s?)[1-79](?:[\.\-\s]?\d\d){4}$/m' # french phone number pattern by default
```