<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Widget\Controller;

use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken\GetColissimoRelayTokenAction;
use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken\GetColissimoRelayTokenInput;
use Dedi\SyliusColissimoPlugin\Widget\Presenter\GetColissimoRelayTokenTwigPresenter;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Model\OrderItemInterface;
use Sylius\Component\Order\Context\CartContextInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;

class ColissimoRelayController extends AbstractController
{
    public function __invoke(
        CartContextInterface $cartContext,
        GetColissimoRelayTokenAction $action,
        GetColissimoRelayTokenTwigPresenter $presenter,
        GetColissimoRelayTokenInput $input,
    ): Response {
        /** @var OrderInterface $cart */
        $cart = $cartContext->getCart();

        $presenter->setWeight(array_reduce($cart->getItems()->toArray(), static fn (int $weight, OrderItemInterface $item) => $weight + $item->getVariant()->getWeight(), 0));

        $action($input, $presenter);

        return $this->render('@DediSyliusColissimoPlugin/Widget/_widget.html.twig', array_merge(
            $presenter->getData(),
            ['cart' => $cart],
        ));
    }
}
