<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Widget\Colissimo;

use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\Adapter\ColissimoAuthenticateHttpClientInterface;
use GuzzleHttp\Client;

class ColissimoAuthenticateHttpClient implements ColissimoAuthenticateHttpClientInterface
{
    private readonly Client $client;

    public function __construct(Client $client)
    {
        $this->client = $client;
    }

    public function getToken(string $login, string $password): string
    {
        $response = $this->client->request(
            'POST',
            ColissimoParameters::DEFAULT_URL_COLISSIMO_AUTH,
            ['json' => ['login' => $login, 'password' => $password]],
        );

        $parsedResponse = json_decode((string) $response->getBody(), true);

        return $parsedResponse['token'] ?? '';
    }
}
