<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\Validator\Constraints;

use Dedi\SyliusColissimoPlugin\Webservice\Enum\SoColissimoEnum;
use Dedi\SyliusColissimoPlugin\Webservice\Model\AddressPickupPointCodeAwareInterface;
use Dedi\SyliusColissimoPlugin\Webservice\Model\ShippingMethodPickupPointAwareInterface;
use Sylius\Component\Core\Model\AddressInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Model\ShippingMethodInterface;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;
use Webmozart\Assert\Assert;

class OrderPickupPointValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint)
    {
        Assert::isInstanceOf($value, OrderInterface::class);

        if (!$constraint instanceof OrderPickupPoint) {
            throw new UnexpectedTypeException($constraint, OrderPickupPoint::class);
        }

        /** @var AddressInterface|AddressPickupPointCodeAwareInterface $shippingAddress */
        $shippingAddress = $value->getShippingAddress();

        Assert::isInstanceOf($shippingAddress, AddressPickupPointCodeAwareInterface::class);

        $hasPickupPoint = $shippingAddress->getPickupPointCode();

        foreach ($value->getShipments() as $shipment) {
            /** @var ShippingMethodInterface|ShippingMethodPickupPointAwareInterface $method */
            $method = $shipment->getMethod();
            Assert::isInstanceOf($method, ShippingMethodPickupPointAwareInterface::class);

            if (null === $method->getGateway() || $method->getGateway() !== SoColissimoEnum::GATEWAY->value) {
                continue;
            }

            if (!is_string($hasPickupPoint)) {
                $this->context->buildViolation($constraint->message)->addViolation();
            }
        }
    }
}
