<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\Form\Extension;

use Sylius\Bundle\ShippingBundle\Form\Type\ShippingMethodType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShippingMethodTypeExtension extends AbstractTypeExtension
{
    final public const PICKUP_TYPE_RELAY = 'relay';

    final public const PICKUP_TYPE_POST_OFFICE = 'post-office';

    final public const PICKUP_TYPE_ALL = 'all';

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('gateway', TextType::class, [
                'required' => false,
            ])
            ->add('pickupPointType', ChoiceType::class, [
                'label' => 'dedi_colissimo_relay.form.pickup_point_type.label',
                'choices' => [
                    'dedi_colissimo_relay.form.pickup_point_type.all' => self::PICKUP_TYPE_ALL,
                    'dedi_colissimo_relay.form.pickup_point_type.post_office' => self::PICKUP_TYPE_POST_OFFICE,
                    'dedi_colissimo_relay.form.pickup_point_type.pickup_relay' => self::PICKUP_TYPE_RELAY,
                ],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'pickupPointType' => self::PICKUP_TYPE_ALL,
        ]);
    }

    public static function getExtendedTypes(): iterable
    {
        return [ShippingMethodType::class];
    }
}
