<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\Form\Extension;

use Dedi\SyliusColissimoPlugin\Webservice\Model\AddressPickupPointCodeAwareInterface;
use Dedi\SyliusColissimoPlugin\Webservice\Validator\Constraints\OrderPickupPoint;
use Sylius\Bundle\CoreBundle\Form\Type\Checkout\SelectShippingType;
use Sylius\Component\Core\Model\AddressInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\RadioType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Webmozart\Assert\Assert;

class SelectShippingTypeExtension extends AbstractTypeExtension
{
    private array $pickupPoint = [];

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('pickupPoint', RadioType::class, [
                'mapped' => false,
                'required' => false,
            ])
        ;

        $builder->addEventListener(FormEvents::PRE_SUBMIT, function (FormEvent $event): void {
            $data = $event->getData();

            $this->pickupPoint = [];

            if (array_key_exists('pickupPoint', $data) && $data['pickupPoint'] !== null && $data['pickupPoint'] !== '') {
                $this->pickupPoint = \json_decode((string) $data['pickupPoint'], true);
            }
        });

        $builder->addEventListener(FormEvents::SUBMIT, function (FormEvent $event): void {
            $order = $event->getData();

            Assert::isInstanceOf($order, OrderInterface::class);

            /** @var AddressInterface|AddressPickupPointCodeAwareInterface $shippingAddress */
            $shippingAddress = $order->getShippingAddress();

            Assert::isInstanceOf($shippingAddress, AddressPickupPointCodeAwareInterface::class);
            Assert::isInstanceOf($shippingAddress, AddressInterface::class);

            if ($this->pickupPoint === []) {
                if (null !== $shippingAddress->getPickupPointCode()) {
                    // in case the current shipping address is a pickup point address, we copy the billing address to the shipping one
                    // this should only occur when we select a pickup point, come back to shipping method choice and then select a non pickup point method.
                    $order->setShippingAddress($order->getBillingAddress());
                }

                return;
            }

            $shippingAddress->setCompany($this->pickupPoint['nom']);
            $shippingAddress->setPostcode($this->pickupPoint['codePostal']);
            $shippingAddress->setCountryCode($this->pickupPoint['codePays']);
            $shippingAddress->setCity($this->pickupPoint['localite']);
            $shippingAddress->setStreet($this->pickupPoint['adresse1']);
            $shippingAddress->setPickupPointCode($this->pickupPoint['identifiant']);
        });
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefault('attr', ['id' => 'sylius_checkout_select_shipping']);
        $resolver->setDefault('constraints', [new OrderPickupPoint(['groups' => ['default', 'sylius']])]);
    }

    public static function getExtendedTypes(): iterable
    {
        return [SelectShippingType::class];
    }
}
