<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\DependencyInjection;

use Dedi\SyliusColissimoPlugin\Widget\Colissimo\ColissimoParameters;
use Sylius\Bundle\CoreBundle\DependencyInjection\PrependDoctrineMigrationsTrait;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;

final class DediSyliusColissimoExtension extends Extension implements PrependExtensionInterface
{
    use PrependDoctrineMigrationsTrait;

    /**
     * @inheritdoc
     */
    public function load(array $config, ContainerBuilder $container): void
    {
        $config = $this->processConfiguration($this->getConfiguration([], $container), $config);
        $loader = new XmlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));

        $loader->load('services.xml');

        if ($config['mode'] === 'webservices') {
            $loader->load('services/webservices.xml');
        } else {
            $loader->load('services/widget.xml');
        }

        $container->setParameter(ColissimoParameters::COLISSIMO_LOGIN, $config['login']);
        $container->setParameter(ColissimoParameters::COLISSIMO_PASSWORD, $config['password']);
        $container->setParameter(ColissimoParameters::COLISSIMO_COUNTRY_LIST, $config['country_list']);
        $container->setParameter(ColissimoParameters::COLISSIMO_WSDL, $config['webservices']['wsdl_colissimo']);
        $container->setParameter(ColissimoParameters::COLISSIMO_DEFAULT_LOCALE, $config['widget']['default_locale']);
        $container->setParameter(ColissimoParameters::COLISSIMO_COUNTRY, $config['widget']['country']);
        $container->setParameter(ColissimoParameters::COLISSIMO_PREPARATION_TIME, $config['widget']['preparation_time']);
        $container->setParameter(ColissimoParameters::COLISSIMO_URL_SERVER, $config['widget']['url_colissimo']);
        $container->setParameter(ColissimoParameters::COLISSIMO_SHIPPING_METHOD_CODE, $config['widget']['shipping_method_code']);
    }

    public function prepend(ContainerBuilder $container)
    {
        $this->prependDoctrineMigrations($container);
    }

    protected function getMigrationsNamespace(): string
    {
        return 'Dedi\SyliusColissimoPlugin\Migrations';
    }

    protected function getMigrationsDirectory(): string
    {
        return '@DediSyliusColissimoPlugin/Migrations';
    }

    protected function getNamespacesOfMigrationsExecutedBefore(): array
    {
        return [
            'Sylius\Bundle\CoreBundle\Migrations',
        ];
    }
}
