<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken;

use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\Adapter\ColissimoAuthenticateHttpClientInterface;

class GetColissimoRelayTokenAction
{
    private readonly ColissimoAuthenticateHttpClientInterface $client;

    public function __construct(ColissimoAuthenticateHttpClientInterface $client)
    {
        $this->client = $client;
    }

    public function __invoke(GetColissimoRelayTokenInputInterface $input, GetColissimoRelayTokenPresenterInterface $presenter)
    {
        $token = $this->client->getToken($input->getLogin(), $input->getPassword());

        $presenter->present(new GetColissimoRelayTokenOutput($token));
    }
}
