<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\ValueObject;

class SearchResults
{
    private array $all = [];

    private array $pickupPoints = [];

    private array $postOffices = [];

    public function addPostOffice(array $postOffice)
    {
        $this->all[] = $postOffice;
        $this->postOffices[] = $postOffice;
    }

    public function getPostOffices(): array
    {
        return $this->postOffices;
    }

    public function addPickupPoint(array $pickupPoint)
    {
        $this->all[] = $pickupPoint;
        $this->pickupPoints[] = $pickupPoint;
    }

    public function getPickupPoints(): array
    {
        return $this->pickupPoints;
    }

    public function getAll(): array
    {
        return $this->all;
    }
}
