<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\ValueObject;

use DateTimeImmutable;
use DateTimeInterface;
use Dedi\SyliusColissimoPlugin\Webservice\Form\Extension\ShippingMethodTypeExtension;

class SearchParameters
{
    private ?string $countryCode = null;

    private string $postalCode = '';

    private string $city = '';

    private ?DateTimeInterface $date;

    private int $weight = 1;

    private ?string $pickupPointType = ShippingMethodTypeExtension::PICKUP_TYPE_ALL;

    public function __construct()
    {
        $this->date = new DateTimeImmutable();
    }

    public function setCountryCode(?string $countryCode): self
    {
        $this->countryCode = is_string($countryCode) ? trim($countryCode) : null;

        return $this;
    }

    public function setPostalCode(string $postalCode): self
    {
        $this->postalCode = trim($postalCode);

        return $this;
    }

    public function setCity(string $city): self
    {
        $this->city = trim($city);

        return $this;
    }

    public function setDate(?DateTimeInterface $date): self
    {
        $this->date = $date;

        return $this;
    }

    public function setWeight(int $weight): self
    {
        if ($weight <= 0) {
            $weight = 1;
        }

        $this->weight = $weight;

        return $this;
    }

    public function setPickupPointType(?string $pickupPointType): self
    {
        $this->pickupPointType = $pickupPointType;

        return $this;
    }

    public function getCountryCode(): ?string
    {
        return $this->countryCode;
    }

    public function getPostalCode(): string
    {
        return $this->postalCode;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function getDate(): DateTimeInterface
    {
        return $this->date;
    }

    public function getWeight(): int
    {
        return $this->weight;
    }

    public function getPickupPointType(): ?string
    {
        return $this->pickupPointType;
    }
}
