<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\Model;

use Dedi\SyliusColissimoPlugin\Webservice\Form\Extension\ShippingMethodTypeExtension;
use Doctrine\ORM\Mapping as ORM;

trait ShippingMethodPickupPointTrait
{
    /** @ORM\Column(name="gateway", type="string", nullable=true) */
    protected $gateway;

    /** @ORM\Column(name="pickupPointType", type="string", nullable=false) */
    protected string $pickupPointType = ShippingMethodTypeExtension::PICKUP_TYPE_ALL;

    public function getGateway(): ?string
    {
        return $this->gateway;
    }

    public function setGateway(?string $gateway): self
    {
        $this->gateway = $gateway;

        return $this;
    }

    public function getPickupPointType(): string
    {
        return $this->pickupPointType;
    }

    public function setPickupPointType(string $pickupPointType): self
    {
        $this->pickupPointType = $pickupPointType;

        return $this;
    }
}
