<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\Form\Type;

use Dedi\SyliusColissimoPlugin\Webservice\Form\Extension\ShippingMethodTypeExtension;
use Dedi\SyliusColissimoPlugin\Webservice\ValueObject\SearchParameters;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SearchPickupPointsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('city', TextType::class, [
                'label' => 'sylius.form.address.city',
                'data' => $options['city'],
                'empty_data' => '',
            ])
            ->add('postalCode', TextType::class, [
                'label' => 'sylius.form.address.postcode',
                'data' => $options['postalCode'],
                'empty_data' => '',
            ])
            ->add('pickupPointType', HiddenType::class, [
                'label' => 'dedi_colissimo_relay.form.pickup_point_type.label',
                'data' => $options['pickupPointType'],
                'empty_data' => ShippingMethodTypeExtension::PICKUP_TYPE_ALL,
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => SearchParameters::class,
            'attr' => [
                'id' => 'dedi_colissimo_search_pickup_points',
            ],
            'city' => null,
            'postalCode' => null,
            'pickupPointType' => ShippingMethodTypeExtension::PICKUP_TYPE_ALL,
        ]);
    }

    public function getBlockPrefix(): string
    {
        return 'dedi_colissimo_search_pickup_points';
    }
}
