<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\Form\Extension;

use Dedi\SyliusColissimoPlugin\Webservice\Model\AddressPickupPointCodeAwareInterface;
use Sylius\Bundle\CoreBundle\Form\Type\Checkout\AddressType;
use Sylius\Component\Core\Model\AddressInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Webmozart\Assert\Assert;

class AddressTypeExtension extends AbstractTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->addEventListener(FormEvents::POST_SUBMIT, function (FormEvent $event): void {
            $order = $event->getData();

            Assert::isInstanceOf($order, OrderInterface::class);

            /** @var AddressInterface|AddressPickupPointCodeAwareInterface $shippingAddress */
            $shippingAddress = $order->getShippingAddress();
            Assert::isInstanceOf($shippingAddress, AddressPickupPointCodeAwareInterface::class);

            /** @var AddressInterface|AddressPickupPointCodeAwareInterface $billingAddress */
            $billingAddress = $order->getBillingAddress();
            Assert::isInstanceOf($billingAddress, AddressPickupPointCodeAwareInterface::class);

            // we make sure pickup point codes are null at this point
            $shippingAddress->setPickupPointCode(null);
            $billingAddress->setPickupPointCode(null);
        });
    }

    public static function getExtendedTypes(): iterable
    {
        return [AddressType::class];
    }
}
