<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\Client;

use Dedi\SyliusColissimoPlugin\Webservice\ValueObject\Credentials;
use SoapClient;

class Client implements ClientInterface
{
    public function __construct(
        private readonly SoapClient $client,
        private readonly Credentials $credentials,
    ) {
    }

    public function call(string $method, array $parameters): object
    {
        $parameters = array_merge([
            'accountNumber' => $this->credentials->getAccountNumber(),
            'password' => $this->credentials->getPassword(),
        ], $parameters);

        return $this->client->__soapCall($method, [$parameters], [
            'exceptions' => true,
        ]);
    }
}
