<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\DependencyInjection;

use Dedi\SyliusColissimoPlugin\Widget\Colissimo\ColissimoParameters;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    /**
     * @inheritdoc
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_colissimo_plugin');
        if (\method_exists($treeBuilder, 'getRootNode')) {
            $rootNode = $treeBuilder->getRootNode();
        } else {
            // BC layer for symfony/config 4.1 and older
            $rootNode = $treeBuilder->root('dedi_sylius_colissimo_plugin');
        }

        $rootNode
            ->children()
                ->scalarNode('mode')
                    ->isRequired()
                    ->defaultValue(ColissimoParameters::DEFAULT_MODE)
                    ->cannotBeEmpty()
                    ->validate()
                        ->ifNotInArray(['webservices', 'widget'])
                        ->thenInvalid('Invalid colissimo mode %s')
                    ->end()
                ->end()
                ->scalarNode('login')
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode('password')
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode('country_list')
                    ->isRequired()
                    ->defaultValue(ColissimoParameters::DEFAULT_COUNTRY_LIST)
                    ->cannotBeEmpty()
                ->end()
                ->arrayNode('webservices')
                ->canBeDisabled()
                    ->children()
                        ->scalarNode('wsdl_colissimo')
                            ->isRequired()
                            ->defaultValue(ColissimoParameters::DEFAULT_WSDL_COLISSIMO)
                            ->cannotBeEmpty()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('widget')
                ->canBeDisabled()
                    ->children()
                        ->scalarNode('default_locale')
                            ->isRequired()
                            ->defaultValue(ColissimoParameters::DEFAULT_LOCALE)
                            ->cannotBeEmpty()
                        ->end()
                        ->scalarNode('country')
                            ->isRequired()
                            ->defaultValue(ColissimoParameters::DEFAULT_COUNTRY)
                            ->cannotBeEmpty()
                        ->end()
                        ->scalarNode('preparation_time')
                            ->isRequired()
                            ->defaultValue(ColissimoParameters::DEFAULT_PREPARATION_TIME)
                            ->cannotBeEmpty()
                        ->end()
                        ->scalarNode('url_colissimo')
                            ->isRequired()
                            ->defaultValue(ColissimoParameters::DEFAULT_URL_COLISSIMO)
                            ->cannotBeEmpty()
                        ->end()
                        ->scalarNode('shipping_method_code')
                            ->isRequired()
                            ->defaultValue(ColissimoParameters::DEFAULT_METHOD_CODE)
                            ->cannotBeEmpty()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
