<?php

declare(strict_types=1);

namespace spec\Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken;

use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\Adapter\ColissimoAuthenticateHttpClientInterface;
use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken\GetColissimoRelayTokenAction;
use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken\GetColissimoRelayTokenInput;
use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken\GetColissimoRelayTokenOutput;
use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken\GetColissimoRelayTokenPresenterInterface;
use PhpSpec\ObjectBehavior;

class GetColissimoRelayTokenActionSpec extends ObjectBehavior
{
    function it_is_initializable(): void
    {
        $this->shouldHaveType(GetColissimoRelayTokenAction::class);
    }

    function let(ColissimoAuthenticateHttpClientInterface $client): void
    {
        $this->beConstructedWith($client);
    }

    function it_get_colissimo_relay_token(
        GetColissimoRelayTokenPresenterInterface $presenter,
        ColissimoAuthenticateHttpClientInterface $client,
        GetColissimoRelayTokenInput $input
    ): void
    {
        $input
            ->getLogin()
            ->willReturn('login')
            ->shouldBeCalledOnce()
        ;

        $input
            ->getPassword()
            ->willReturn('password')
            ->shouldBeCalledOnce()
        ;

        $client
            ->getToken('login', 'password')
            ->willReturn('1234567890')
            ->shouldBeCalledOnce()
        ;

        $expected = new GetColissimoRelayTokenOutput('1234567890');

        $presenter->present($expected)->shouldBeCalledOnce();

        $this->__invoke($input, $presenter);
    }
}
