<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Widget\Presenter;

use Dedi\SyliusColissimoPlugin\Widget\Colissimo\ColissimoParameters;
use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken\GetColissimoRelayTokenOutputInterface;
use Dedi\SyliusColissimoPlugin\Widget\Domain\ColissimoRelay\UseCase\GetColissimoRelayToken\GetColissimoRelayTokenPresenterInterface;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

class GetColissimoRelayTokenTwigPresenter implements GetColissimoRelayTokenPresenterInterface
{
    private string $token;

    private readonly ParameterBagInterface $params;

    private float $weight = 0.0;

    public function __construct(ParameterBagInterface $params)
    {
        $this->params = $params;
    }

    public function setWeight(float $weight): self
    {
        $this->weight = $weight;

        return $this;
    }

    public function present(GetColissimoRelayTokenOutputInterface $output): void
    {
        $this->token = $output->getToken();
    }

    public function getData(): array
    {
        return [
            'token' => $this->token,
            'ceLang' => $this->params->get(ColissimoParameters::COLISSIMO_DEFAULT_LOCALE),
            'ceCountryList' => $this->params->get(ColissimoParameters::COLISSIMO_COUNTRY_LIST),
            'ceCountry' => $this->params->get(ColissimoParameters::COLISSIMO_COUNTRY),
            'dyPreparationTime' => $this->params->get(ColissimoParameters::COLISSIMO_PREPARATION_TIME),
            'URLColissimo' => $this->params->get(ColissimoParameters::COLISSIMO_URL_SERVER),
            'dyWeight' => $this->weight,
            'shippingMethodCode' => $this->params->get(ColissimoParameters::COLISSIMO_SHIPPING_METHOD_CODE),
        ];
    }
}
