<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Widget\Form\Extension;

use Sylius\Bundle\AddressingBundle\Form\Type\AddressType as SyliusAddressType;
use Sylius\Bundle\CoreBundle\Form\Type\Checkout\SelectShippingType;
use Sylius\Component\Core\Model\OrderInterface;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Valid;
use Webmozart\Assert\Assert;

class SelectShippingTypeExtension extends AbstractTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->addEventListener(FormEvents::PRE_SET_DATA, static function (FormEvent $event): void {
            $form = $event->getForm();

            $order = $event->getData();
            Assert::isInstanceOf($order, OrderInterface::class);

            $channel = $order->getChannel();

            $form
                ->add('shippingAddress', SyliusAddressType::class, [
                    'shippable' => true,
                    'constraints' => [new Valid()],
                    'channel' => $channel,
                ])
            ;
        });
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefault('attr', ['id' => 'sylius_checkout_select_shipping']);
    }

    public static function getExtendedTypes(): iterable
    {
        return [SelectShippingType::class];
    }
}
