<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\Request;

use Dedi\SyliusColissimoPlugin\Webservice\Client\ClientInterface;
use Dedi\SyliusColissimoPlugin\Webservice\Factory\SearchResultsFactory;
use Dedi\SyliusColissimoPlugin\Webservice\ValueObject\SearchParameters;
use Dedi\SyliusColissimoPlugin\Webservice\ValueObject\SearchResults;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Order\Context\CartContextInterface;

class SearchPickupPointsRequest implements SearchPickupPointsRequestInterface
{
    public function __construct(
        private readonly ClientInterface $client,
        private readonly SearchResultsFactory $factory,
        private readonly CartContextInterface $cartContext,
    ) {
    }

    public function search(SearchParameters $parameters): SearchResults
    {
        if (null === $parameters->getCountryCode()) {
            /** @var OrderInterface $cart */
            $cart = $this->cartContext->getCart();

            $parameters->setCountryCode($cart->getShippingAddress()->getCountryCode());
        }

        $response = $this->client->call('findRDVPointRetraitAcheminement', [
            'zipCode' => $parameters->getPostalCode(),
            'city' => $parameters->getCity(),
            'weight' => $parameters->getWeight(),
            'countryCode' => $parameters->getCountryCode(),
            'shippingDate' => $parameters->getDate()->format('d/m/Y'),
            'optionInter' => 1,
            'pickupPointType' => $parameters->getPickupPointType(),
        ]);

        return $this->factory->create($response);
    }
}
