<?php

declare(strict_types=1);

namespace Dedi\SyliusColissimoPlugin\Webservice\Factory;

use Dedi\SyliusColissimoPlugin\Webservice\Enum\SoColissimoEnum;
use Dedi\SyliusColissimoPlugin\Webservice\Exception\SearchPickupPointsException;
use Dedi\SyliusColissimoPlugin\Webservice\ValueObject\SearchResults;

class SearchResultsFactory implements SearchResultsFactoryInterface
{
    public function create(object $results): SearchResults
    {
        $results = \json_decode(\json_encode($results), true, 512, \JSON_THROW_ON_ERROR);

        if (isset($results['return']['errorCode']) && 0 !== (int) $results['return']['errorCode']) {
            $error = 'Unexpected error';
            if (isset($results['return']['errorMessage']) && '' !== $results['return']['errorMessage']) {
                $error = $results['return']['errorMessage'];
            }

            throw new SearchPickupPointsException($error, (int) $results['return']['errorCode']);
        }

        $searchResults = new SearchResults();

        $pickupPoints = $results['return']['listePointRetraitAcheminement'];

        foreach ($pickupPoints as $pickupPoint) {
            if (\in_array($pickupPoint['typeDePoint'], [SoColissimoEnum::PICKUP_TYPE_A2P->value, SoColissimoEnum::PICKUP_TYPE_CMT->value], true)) {
                $searchResults->addPickupPoint($pickupPoint);

                continue;
            }
            $searchResults->addPostOffice($pickupPoint);
        }

        return $searchResults;
    }
}
