export default class ColissimoWebservice {
    constructor(options) {
        options = options || {};
        const defaults = {
            shippingMethodsContainer: document.querySelector('#sylius-shipping-methods'),
            form: document.querySelector('#dedi_colissimo_search_pickup_points'),
            getData: (className) => {
                const data = {};
                const that = this;
                data[this.options.form.id] = {};
                const fields = ['city', 'postalCode', 'country', 'pickupPointType', '_token'];
                const fieldElements = document.querySelectorAll('.' + className);

                for (const i in fields) {
                    const fieldName = fields[i];

                    fieldElements.forEach(function(element) {
                        let fieldElement = element.querySelector(`#${that.options.form.id}_${fieldName}`);
                        if (fieldElement) {
                            data[that.options.form.id][fieldName] = fieldElement.value;
                        }
                    });
                }

                return data;
            },
            success: (json) => {
                document.querySelector('[data-colissimo-pickup-points]').innerHTML = json.html;
            },
            error: (json) => {
            },
        };
        this.options = Object.assign(defaults, options)

        if (null !== this.options.form) {
            this.options['url'] = this.options.form.dataset.url;
        }

        this.bindEvents();
        this.initializeSearchFormDisplay();
    }

    bindEvents() {
        const that = this;

        this.options.shippingMethodsContainer
            .querySelectorAll('[id^="sylius_checkout_select_shipping_shipments_"]')
            .forEach(function(element) {
               element.addEventListener('change', () => {
                   that.initializeSearchFormDisplay();
               })
            });
    }

    initializeSearchFormDisplay() {
        const that = this;

        this.options.shippingMethodsContainer
            .querySelectorAll('.search-pickup-points')
            .forEach(function(element) {
                const relatedRadioInput = element.previousElementSibling.querySelector('[id^="sylius_checkout_select_shipping_shipments_"]');
                if (relatedRadioInput.checked === false) {
                    element.style.display = 'none';
                    let results = document.querySelector('[data-colissimo-pickup-points]');
                    if (results && element.contains(results)) {
                        element.removeChild(results);
                    }
                } else {
                    element.style.display = 'block';
                    let results = document.createElement('div');
                    results.setAttribute('data-colissimo-pickup-points', '');
                    element.appendChild(results);
                    that.fetchPickupPoints(element.className.split(' ')[0]);
                }
            });
    }

    fetchPickupPoints(className) {
        fetch(this.options.url, {
            method: 'POST',
            body: JSON.stringify(this.options.getData(className)),
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            },
        })
            .then(response => {
                if (!response.ok) {
                    return response.text().then(text => {
                        throw Error(text)
                    });
                }
                return response;
            })
            .then(response => response.json())
            .then(json => {
                this.options.success(json);
            })
            .catch(error => {
                this.options.error(error);
            });
    }
}