
For a comprehensive guide on Sylius Plugins development please go to Sylius documentation,
there you will find the <a href="https://docs.sylius.com/en/latest/plugin-development-guide/index.html">Plugin Development Guide</a>, that is full of examples.

## Quickstart Installation

```bash
$ make start
$ make db-create
$ make db-update
$ make fixtures
$ make build
```

## Usage

### Running plugin tests

- PHPUnit

```bash
$ vendor/bin/phpunit
```

- PHPSpec

```bash
$ vendor/bin/phpspec run
```

- Behat (non-JS scenarios)

```bash
$ vendor/bin/behat --tags="~@javascript"
```

- Behat (JS scenarios)

1. Download [Chromedriver](https://sites.google.com/a/chromium.org/chromedriver/)

2. Download [Selenium Standalone Server](https://www.seleniumhq.org/download/).

2. Run Selenium server with previously downloaded Chromedriver:

    ```bash
    $ java -Dwebdriver.chrome.driver=chromedriver -jar selenium-server-standalone.jar
    ```
    
3. Run test application's webserver on `localhost:8080`:

    ```bash
    $ (cd tests/Application && bin/console server:run localhost:8080 -d public -e test)
    ```

4. Run Behat:

    ```bash
    $ vendor/bin/behat --tags="@javascript"
    ```

### Opening Sylius with your plugin

After installation and with docker containers running, go to http://0.0.0.0:9000/
