<p align="center">
    <a href="https://sylius.com" target="_blank">
        <img src="https://demo.sylius.com/assets/shop/img/logo.png" />
    </a>
</p>

<p align="center">
    <a href="https://sylius.com" target="_blank">
        <img src="https://www.dedi-agency.com/wp-content/uploads/2014/05/Dedi_logo_HD.png" />
    </a>
</p>


<h1 align="center">Colissimo Plugin</h1>

<p align="center">Colissimo plugin for Sylius.</p>

# Installation

### Require the plugin with composer :

```bash
composer require dedi/sylius-colissimo-plugin
```

### Add plugin class to your bundles.php :
```php
<?php
$bundles = [
    // ...
    Dedi\SyliusColissimoPlugin\DediSyliusColissimoPlugin::class => ['all' => true],
    // ...
];
```

### Add configuration :

```dotenv
# .env

COLISSIMO_LOGIN=XXX
COLISSIMO_PASSWORD=XXX
```

```yaml
# config/packages/dedi_sylius_colissimo_plugin.yaml

dedi_sylius_colissimo:
  mode: 'webservices'
  login: '%env(COLISSIMO_LOGIN)%'
  password: '%env(COLISSIMO_PASSWORD)%'
  country_list: 'FR'
  webservices: # optional - only used if mode = 'webservices"
    wsdl_colissimo: 'https://ws.colissimo.fr/pointretrait-ws-cxf/PointRetraitServiceWS/2.0?wsdl'
  widget: # optional - only used if mode = 'widget"
    default_locale: 'fr'
    country: 'FR'
    preparation_time: 1
    url_colissimo: 'https://ws.colissimo.fr'
    shipping_method_code: 'fedex'
```

### Import routes
```yaml
# config/routes/dedi_sylius_colissimo_plugin.yaml

# if mode = webservices
dedi_colissimo_webservices:
  resource: "@DediSyliusColissimoPlugin/Resources/config/routes/webservices.xml"
  
# if mode = widget
dedi_colissimo_widget:
  resource: "@DediSyliusColissimoPlugin/Resources/config/routes/widget.xml"
```

### "webservice" mode only configuration :

#### Copy templates
```shell
mkdir -p templates/bundles/SyliusShopBundle/
cp -R vendor/dedi/sylius-colissimo-plugin/src/Resources/views/SyliusShopBundle/* templates/bundles/SyliusShopBundle/
```

#### Add css
```twig
# templates/SyliusShopBundle/_styles.html.twig
{% include '@SyliusUi/_stylesheets.html.twig' with {'path': 'bundles/dedisyliuscolissimoplugin/css/shipping/style.css'} %}
```

#### Add JavaScript
Create this JavaScript file in your assets

```javascript
// assets/MyProject/js/pickup-point-colissimo/index.js
import ColissimoWebservice from 'colissimoWebService/sylius-colissimo-plugin/src/Resources/public/js/webservice/colissimo-webservice';

document.addEventListener('DOMContentLoaded', () => {
    new ColissimoWebservice({
        success(json) {
            document.querySelector('[data-colissimo-pickup-points]').innerHTML = json.html;
        },
        error(error) {
            document.querySelector('[data-colissimo-pickup-points]').innerHTML = '<p>{{ 'dedi_colissimo_relay.ui.search_pickup_points.error'|trans }}</p>';
        },
    });
});
```

Then update this line in the template to match with your project name

```twig
# templates/SyliusShopBundle/Checkout/selectShipping.html.twig
{% block javascripts %}
    {{ encore_entry_script_tags('pickup-point-colissimo', null, 'dedi-pickup-point-colissimo') }}
{% endblock %}
```

And update your webpack config

```javascript
// webpack.config.js
Encore
    .addEntry('pickup-point-colissimo', './assets/MyProject/js/pickup-point-colissimo')
    .addAliases({
        colissimoWebService: path.resolve(__dirname, 'vendor/dedi'),
    });
```

#### Modify your entities

Make sure you `Address` and `ShippingMethod` entities implements the bundle interfaces.

```php
use Dedi\SyliusColissimoPlugin\Webservice\Model\AddressPickupPointCodeAwareInterface;
use Dedi\SyliusColissimoPlugin\Webservice\Model\AddressPickupPointCodeTrait;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Address as BaseAddress;

/**
 * @ORM\Entity
 * @ORM\Table(name="sylius_address")
 */
class Address extends BaseAddress implements AddressPickupPointCodeAwareInterface
{
    use AddressPickupPointCodeTrait;
}
```

```php
use Dedi\SyliusColissimoPlugin\Webservice\Model\ShippingMethodPickupPointAwareInterface;
use Dedi\SyliusColissimoPlugin\Webservice\Model\ShippingMethodPickupPointTrait;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\ShippingMethod as BaseShippingMethod;

/**
 * @ORM\Entity
 * @ORM\Table(name="sylius_shipping_method")
 */
class ShippingMethod extends BaseShippingMethod implements ShippingMethodPickupPointAwareInterface
{
    use ShippingMethodPickupPointTrait;
}
```

### Import ShippingMethod form

```yaml
#config/packages/sylius_ui.yaml
imports:
- { resource: "@DediSyliusColissimoPlugin/Resources/config/config.yaml" }
```

#### Execute migrations

```shell
bin/console doctrine:migrations:migrate
```

#### Set the gateway

On your colissimo shipping method in the admin interface, make sure to set `sylius_colissimo` as the `Gateway` in the corresponding field. 

### "widget" mode only configuration :
```yaml
# config/packages/sylius_ui.yaml
sylius_ui:
  events:
    sylius.shop.checkout.select_shipping.before_form:
      blocks:
        colissimo_widget:
          template: '@DediSyliusColissimoPlugin/Widget/colissimo_widget.html.twig'
```


# Documentation

## ColissimoWebservice options

`shippingMethodsContainer` : element containing shipping method list
- type : `Element`
- default: `document.querySelector('#sylius-shipping-methods')`

`form` : element containing the pickup point search form
- type : `Element`
- default: `document.querySelector('#dedi_colissimo_search_pickup_points')`

`submitBtn` : the button triggering the pickup point search request
- type : `Element`
- default: `document.querySelector('#dedi_colissimo_search_pickup_points_btn_submit')`

`getData` : method returning json data to be sent to XHR
- type : `callback`
- default : 
```javascript
getData : () => {
    const data = {};
    data[this.options.form.id] = {};
    
    const fields = ['city', 'postalCode', 'country', '_token'];
    for (const i in fields) {
        const fieldName = fields[i];
        const fieldElement = this.options.form.querySelector(`#${this.options.form.id}_${fieldName}`);
        if (fieldElement) {
            data[this.options.form.id][fieldName] = fieldElement.value;
        }
    }

    return data;
}
```

`success` : method called on successful XHR request
- type : `callback`
- parameter : `json` response 
- default : 
```javascript
success: (json) => {
    document.querySelector('[data-colissimo-pickup-points]').innerHTML = json.html;
}

```
`error` : method called on XHR request error
- type : `callback`
- parameter : `json` response error
- default : 
```javascript
error: (json) => {
}
```

## Overriding templates : 

- Search form : `@DediSyliusColissimoPlugin/Search/_form.html.twig`
- Search results : `@DediSyliusColissimoPlugin/Search/_pickupPoints.html.twig`

## Contributing

[Documentation](docs/CONTRIBUTING.md)
