<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Utils\BlockList;

use MonsieurBiz\SyliusRichEditorPlugin\UiElement\Registry;
use MonsieurBiz\SyliusRichEditorPlugin\UiElement\UiElementInterface;

class BlockList implements BlockListInterface
{
    final public const TAG = 'embeddable';

    private readonly Registry $registry;

    public function __construct(Registry $registry)
    {
        $this->registry = $registry;
    }

    public function getList(): array
    {
        return array_reduce($this->registry->getUiElements(), function (array $list, UiElementInterface $element): array {
            $data = $element->jsonSerialize();

            if (in_array(self::TAG, $data['tags'], true) && false === $data['ignored']) {
                $list[] = [
                    'name' => $this->formatCode($element->getCode()),
                    'type' => $element->getFormClass(),
                    'label' => $element->getTitle(),
                    'shop_template' => $element->getFrontRenderTemplate(),
                    'admin_template' => $element->getAdminRenderTemplate(),
                ];
            }

            return $list;
        }, []);
    }

    public function getElementByName(string $name): ?array
    {
        foreach ($this->getList() as $item) {
            if ($item['name'] === $name) {
                return $item;
            }
        }

        return null;
    }

    private function formatCode(string $code): string
    {
        return str_replace('.', '_', $code);
    }
}
