<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Twig;

use FOS\CKEditorBundle\Config\CKEditorConfigurationInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

final class CKEditorExtension extends AbstractExtension
{
    private readonly CKEditorConfigurationInterface $configuration;

    private readonly ?string $name;

    public function __construct(CKEditorConfigurationInterface $configuration, ?string $name)
    {
        $this->configuration = $configuration;
        $this->name = $name;
    }

    public function getFunctions()
    {
        return [
            new TwigFunction('ckeditor_config', [$this, 'getConfig']),
            new TwigFunction('ckeditor_styles', [$this, 'getStyles']),
        ];
    }

    public function getConfig(?string $name = null): array
    {
        if (null === $name) {
            $name = $this->name ?? $this->configuration->getDefaultConfig();
        }

        return $this->configuration->getConfig($name);
    }

    public function getStyles(): array
    {
        return $this->configuration->getStyles();
    }
}
