<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin\Form\Type;

use BitBag\SyliusCmsPlugin\Entity\Block;
use BitBag\SyliusCmsPlugin\Form\Type\BlockType;
use Dedi\SyliusCmsPlugin\Entity\BlockAwareInterface;
use Symfony\Component\Form\Exception\UnexpectedTypeException;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

trait BlockAwareTraitType
{
    public function buildBlockAwareForm(FormBuilderInterface $builder, array $options)
    {
        /** @var BlockAwareInterface $subject */
        $subject = $options['data'];

        $builder
            ->add('block', BlockType::class, [
                'label' => 'bitbag_sylius_cms_plugin.ui.cms',
                'data' => $subject->getBlock() ?? new Block(),
                'block_prefix' => 'dedi_block_aware_type',
            ])
            ->addEventListener(FormEvents::POST_SUBMIT, function (FormEvent $event): void {
                /** @var BlockAwareInterface $subject */
                $subject = $event->getData();

                if (!$subject instanceof BlockAwareInterface) {
                    throw new UnexpectedTypeException($subject, BlockAwareInterface::class);
                }

                if (null === $subject->getBlock()) {
                    return;
                }

                $subject->getBlock()->setCode($subject->generateBlockCode());
            })
        ;
    }
}
