<?php

declare(strict_types=1);

namespace Dedi\SyliusCmsPlugin;

use Dedi\SyliusCmsPlugin\DependencyInjection\DediSyliusCmsExtension;
use Sylius\Bundle\CoreBundle\Application\SyliusPluginTrait;
use Symfony\Component\DependencyInjection\Extension\ExtensionInterface;
use Symfony\Component\HttpKernel\Bundle\Bundle;

final class DediSyliusCmsPlugin extends Bundle
{
    use SyliusPluginTrait;

    public function getContainerExtension(): ?ExtensionInterface
    {
        if (null === $this->extension) {
            $this->extension = new DediSyliusCmsExtension();
        }

        return $this->extension;
    }
}
